/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWCachedSecurityList;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWParticipantListCellRenderer;
import java.util.Vector;
import javax.swing.JDialog;

public class VWParticipantsPanel
extends VWUsersAndGroupsPanel {
    public static final int WFLGROUPS = 0;
    public static final int USERS = 1;
    protected VWParticipantItem[] m_wflGroupItems = null;
    protected int m_nType = 0;

    public VWParticipantsPanel(JDialog parentDialog, VWSession vwSession) {
        try {
            this.m_vwSession = vwSession;
            this.m_availableParticipants = VWCachedSecurityList.getUsersAndGroupsParticipant(this.m_vwSession);
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(parentDialog, ex.getLocalizedMessage(), 1);
            this.m_availableParticipants = null;
        }
    }

    public void init(VWParticipantItem[] selectedParticipantItems, VWParticipantItem[] wflGroupList) {
        try {
            if (wflGroupList != null && wflGroupList.length > 0) {
                this.m_wflGroupItems = new VWParticipantItem[wflGroupList.length];
                System.arraycopy(wflGroupList, 0, this.m_wflGroupItems, 0, wflGroupList.length);
            }
            super.init(selectedParticipantItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasWorkflowGroups() {
        return this.m_wflGroupItems != null && this.m_wflGroupItems.length > 0;
    }

    public void refreshLists(int nType) {
        this.m_nType = nType;
        this.initializeParticipantsLists(this.getSelectedItems());
    }

    protected void initializeParticipantsLists(Object[] selectedNames) {
        try {
            this.setListCellRenderer(new VWParticipantListCellRenderer());
            if (this.m_nType == 0) {
                super.initializeLists(this.m_wflGroupItems, selectedNames, this.m_availableParticipants);
            } else {
                super.initializeLists(this.m_availableParticipants, selectedNames, this.m_wflGroupItems);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected String getFormattedName(String participantName) {
        boolean bAddQuotes = true;
        String formattedName = null;
        try {
            if (this.m_wflGroupItems != null) {
                for (int nIndex = 0; nIndex < this.m_wflGroupItems.length; ++nIndex) {
                    if (VWStringUtils.compare(participantName, this.m_wflGroupItems[nIndex].getName()) != 0) continue;
                    bAddQuotes = false;
                    break;
                }
            }
            formattedName = bAddQuotes ? '\"' + participantName + '\"' : participantName;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return formattedName;
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        block6: {
            String itemStr;
            boolean user;
            block7: {
                user = false;
                itemStr = null;
                int itemLen = items.length;
                if (this.m_wflGroupItems != null) break block7;
                if (this.m_nType != 0) break block6;
                for (int i = 0; i < itemLen; ++i) {
                    items[i] = null;
                }
                break block6;
            }
            int wflGroupLen = this.m_wflGroupItems.length;
            for (int i = itemLen - 1; i >= 0; --i) {
                itemStr = null;
                if (items[i] == null || !(items[i] instanceof VWParticipantItem)) {
                    items[i] = null;
                    break;
                }
                itemStr = ((VWParticipantItem)items[i]).getName();
                for (int j = 0; j < wflGroupLen; ++j) {
                    String wflGroupName = this.m_wflGroupItems[j].getName();
                    if (this.m_nType == 0) {
                        if (VWStringUtils.compare(itemStr, wflGroupName) != 0) {
                            user = true;
                            continue;
                        }
                        user = false;
                        break;
                    }
                    if (this.m_nType != 1 || VWStringUtils.compare(itemStr, wflGroupName) != 0) continue;
                    items[i] = null;
                    break;
                }
                if (this.m_nType != 0 || !user) continue;
                items[i] = null;
            }
        }
        return this.removeNullElementsFromArray(items);
    }

    protected VWParticipantItem getParticipantItem(String userName, String[] groupNames) {
        try {
            int i;
            if (this.m_wflGroupItems != null && this.m_wflGroupItems.length > 0) {
                for (i = 0; i < this.m_wflGroupItems.length; ++i) {
                    if (VWStringUtils.compare(userName, this.m_wflGroupItems[i].getName()) != 0) continue;
                    return new VWParticipantItem(userName, 2);
                }
            }
            if (groupNames != null && groupNames.length > 0) {
                for (i = 0; i < groupNames.length; ++i) {
                    if (VWStringUtils.compare(userName, groupNames[i]) != 0) continue;
                    return new VWParticipantItem(userName, 1);
                }
            }
            return new VWParticipantItem(userName, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private Object[] removeNullElementsFromArray(Object[] items) {
        Vector<Object> tempVector = new Vector<Object>();
        Object[] newArray = null;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            tempVector.add(items[i]);
        }
        if (tempVector.size() > 0) {
            newArray = new Object[tempVector.size()];
            tempVector.copyInto(newArray);
        }
        return newArray;
    }
}

